#version 330
#extension GL_EXT_gpu_shader4 : enable
// nebula 112Mod01.fsh  by   aodnawg

//https://www.shadertoy.com/view/WtKGDh
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float n11(float p) {
	return fract(sin(p*154.101)*313.019);
} 
float n21(vec2 p) {
    float n = sin(dot(p, vec2(7, 157)));    
    return n;
}
vec3 hash33(vec3 p){ 
    float n = sin(dot(p, vec3(7, 157, 113)));    
    return fract(vec3(2097152, 262144, 32768)*n); 
}

float voronoi(vec3 p){
	vec3 b, r, g = floor(p);
	p = fract(p);
	float d = 1.; 
	for(int j = -1; j <= 1; j++) {
	    for(int i = -1; i <= 1; i++) {
		    b = vec3(i, j, -1);
		    r = b - p + hash33(g+b);
		    d = min(d, dot(r,r));
		    b.z = 0.0;
		    r = b - p + hash33(g+b);
		    d = min(d, dot(r,r));
		    b.z = 1.;
		    r = b - p + hash33(g+b);
		    d = min(d, dot(r,r));
	    }
	}
	
	return d; // Range: [0, 1]
}

vec3 hsl2rgb( in vec3 c ){
    vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0,1.0);
    return c.z + c.y * (rgb-0.5)*(1.0-abs(2.0*c.z-1.0));
}

float nebula(in vec3 p) {
    float amp = 1., sum=0., z= 1., m = 0.;
    for(int i=1; i<=10;i++){
    	vec3 t = vec3(0., 0., p.z+iTime*.1);
        z *= 2.;
        m += voronoi(vec3(p.xy*z, 1.)+t) *amp;
        sum += amp;
        amp *= .5;
    }
    m /= sum;
    return pow(m, 1.5);
}

float star(vec3 p) {
    float z = 16.;
    float t = p.z;
    vec2 gv = fract(p.xy*z)-.5;
    vec2 id = floor(p.xy*z);
    gv.x += sin(n21(id)*354.23)*.3;
    gv.y += sin(n11(n21(id))*914.19)*.3;
    float r = n11(n21(id));
    float m =  .1*n11(r)*abs(sin(p.z+r*133.12))*.4/length(gv)*.1;
    return m;
}

float stars(in vec3 p) {
    float z= 1., m = 0.;
    for(int i=1; i<=10;i++){
    	vec3 t = vec3(0., 0., p.z+iTime*.2);
        z *= 2.;
         m += star(vec3(p.xy*z, 1.)+t);
    }
    return m;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
    vec3 col = vec3(.0);
    
    vec3 col1 = normalize(vec3(159., 38., 106.))*nebula(vec3(uv,1.));
    vec3 col2 = normalize(vec3(106., 110., 185.))*nebula(vec3(uv,1298.));
    col += mix(col1,col2,5.);
    float m = stars(vec3(uv, iTime*2.));
    col += vec3(m);

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}